/* "Klaatu barada nikto" (gracias Paco <http://www.aristarco.org/index.htm> por la idea)

El 16 de Noviembre de 2014 , 40 años despues de la unica transmisión del "Mensaje de Arecicbo",
desarrollamos en Os Biocos (San Juan de Rio, Ourense, España) el OFF Astrobiocos y el V Encuentro
de Radiaoficion y Cacharreo. 

Para conmemorar los 40 años de la tranmisión de Arecibo, reproducimos la retransmisión del mensaje
original de Arecibo en la fecuencia de 2380 MHz, mediante una antena disenada y cosntruida a medida,
acorde a la línea de la antena original.

La generacion del mensaje, así como de la información adicional en CW, corrió a cargo de una placa
Arduino Duemilanove, corriendo este programa

Esta basado en los trabajos de:

Bill Brown WB8ELK <http://www.wb8elk.com>

Matthew Huges <http://matthewhughes.info/>

y el equipo de cacharreo.es <http://cacharreo.es> EA1GDH, EA1HVT, EB1AJP, EB1HBK, EB1WM
*/

#include <Flash.h> // necesitas esta libreria antes de compliar y cargar el progrma en el arduino

//***********************************************************************************************************
//******************** CONFIGURACION DE LA IDENTIFICACIÓN DE LA BALIZA BALIZINO *****************************
//***********************************************************************************************************
// al especificar la longitud de las cadenas hay que incluir espacio para el caracter "nulo" de fin de cadena
// NOTA******** Las cadenas "callsign" y "locator" deben configurarse con el distintivo y ubicación adecuados
// dejando ademas un espacio en blanco al final ANTES DE CARGAR EL PROGRAMA EN EL ARDUINO *******************
//***********************************************************************************************************

char vvv[6] = {'V','V','V',' ',' '};              // bloque de tres "V" que identifica el TX de las balizas
char callsign[8] = {'E','E','1','R','K','O',' '}; // SUSTIUIR LOS NUMEROS POR EL DISTINTIVO DE LA ESTACION DE RADIO
char locator[8] = {'I','N','6','2','I','J',' '};  // SUSTITUIR LAS LETRAS POR EL LOCATOR GEOGRAFICO DE LA ESTACION


char frase[21] = {'K','L','A','A','T','U',' ','B','A','R','A','D','A',' ','N','I','K','T','O',' '};


char memorial[27] = {'I','N',' ','M','E','M','O','R','I','A','M',' ','M','A','R','G','A',' ','M','U','R','I','L','L','O',' '};




//************************************************************************************************************


// ********************************************************
// ASCII to Morse Code Lookup Table
// ********************************************************

const unsigned char morse_table[63] = { 	// Morse Code Lookup table

	0b00000001,	//;sp - 0x20 
	0b01001010,	//; ! - 0x21
	0b01101101,	//; " - 0x22
	0b01011110,	//; # - 0x23 // Not available in Morse Code - replace with "-"
	0b10110111,	//; $ - 0x24
	0b01011110,	//; % - 0x25 // Not available in Morse Code - replace with "-"
	0b00111101,	//; & - 0x26
	0b01100001,	//; ' - 0x27
	0b00110010,	//; ( - 0x28
	0b01010010,	//; ) - 0x29
	0b01011110,	//; * - 0x2A // Not available in Morse Code - replace with "-"
	0b00110101,	//; + - 0x2B 
	0b01001100,     //; , - 0x2C
	0b01011110,     //; - - 0x2D
	0b01010101,     //; . - 0x2E
	0b00110110,	//; / - 0x2F
	0b00100000,	//; 0 - 0x30
	0b00100001,	//; 1 - 0x31
	0b00100011,	//; 2 - 0x32
	0b00100111,	//; 3 - 0x33
	0b00101111,	//; 4 - 0x34
	0b00111111,	//; 5 - 0x35
	0b00111110,	//; 6 - 0x36
	0b00111100,	//; 7 - 0x37
	0b00111000,	//; 8 - 0x38
	0b00110000,	//; 9 - 0x39
	0b01111000,	//; : - 0x3A
	0b00101010,	//; ; - 0x3B
	0b00110010,	//; < - 0x3C // send ( since no < in Morse
	0b00101110,	//; = - 0x3D 
	0b01010010,	//; > - 0x3E // send ) since no > in Morse
	0b01110011,	//; ? - 0x3F
	0b01101001,	//; @ - 0x40 
	0b00000101,	//; A - 0x41
	0b00011110,	//; B - 0x42
	0b00011010,	//; C - 0x43
	0b00001110,	//; D - 0x44
	0b00000011,	//; E - 0x45
	0b00011011,	//; F - 0x46
	0b00001100,	//; G - 0x47
	0b00011111,	//; H - 0x48
	0b00000111,	//; I - 0x49
	0b00010001,	//; J - 0x4A
	0b00001010,	//; K - 0x4B
	0b00011101,	//; L - 0x4C
	0b00000100,	//; M - 0x4D
	0b00000110,	//; N - 0x4E
	0b00001000,	//; O - 0x4F
	0b00011001,	//; P - 0x50
	0b00010100,	//; Q - 0x51
	0b00001101,	//; R - 0x52
	0b00001111,	//; S - 0x53
	0b00000010,	//; T - 0x54
	0b00001011,	//; U - 0x55
	0b00010111,	//; V - 0x56
	0b00001001,	//; W - 0x57
	0b00010110,	//; X - 0x58
	0b00010010,	//; Y - 0x59
	0b00011100	//; Z - 0x5A
	
};

// END of Morse Table


FLASH_STRING(big_string, 
  "00000010101010000000000"
  "00101000001010000000100"
  "10001000100010010110010"
  "10101010101010100100100"
  "00000000000000000000000"
  "00000000000011000000000"
  "00000000001101000000000"
  "00000000001101000000000"
  "00000000010101000000000"
  "00000000011111000000000"
  "00000000000000000000000"
  "11000011100011000011000"
  "10000000000000110010000"
  "11010001100011000011010"
  "11111011111011111011111"
  "00000000000000000000000"
  "00010000000000000000010"
  "00000000000000000000000"
  "00001000000000000000001"
  "11111000000000000011111"
  "00000000000000000000000"
  "11000011000011100011000"
  "10000000100000000010000"
  "11010000110001110011010"
  "11111011111011111011111"
  "00000000000000000000000"
  "00010000001100000000010"
  "00000000001100000000000"
  "00001000001100000000001"
  "11111000001100000011111"
  "00000000001100000000000"
  "00100000000100000000100"
  "00010000001100000001000"
  "00001100001100000010000"
  "00000011000100001100000"
  "00000000001100110000000"
  "00000011000100001100000"
  "00001100001100000010000"
  "00010000001000000001000"
  "00100000001100000000100"
  "01000000001100000000100"
  "01000000000100000001000"
  "00100000001000000010000"
  "00010000000000001100000"
  "00001100000000110000000"
  "00100011101011000000000"
  "00100000001000000000000"
  "00100000111110000000000"
  "00100001011101001011011"
  "00000010011100100111111"
  "10111000011100000110111"
  "00000000010100000111011"
  "00100000010100000111111"
  "00100000010100000110000"
  "00100000110110000000000"
  "00000000000000000000000"
  "00111000001000000000000"
  "00111010100010101010101"
  "00111000000000101010100"
  "00000000000000101000000"
  "00000000111110000000000"
  "00000011111111100000000"
  "00001110000000111000000"
  "00011000000000001100000"
  "00110100000000010110000"
  "01100110000000110011000"
  "01000101000001010001000"
  "01000100100010010001000"
  "00000100010100010000000"
  "00000100001000010000000"
  "00000100000000010000000"
  "00000001001010000000000"
  "01111001111101001111000"
);


int adclen;
byte morse;
byte cwlen;
byte cw;

byte x;
char asciibuf[5];

int tone2=0;


int ptt = 12; // PTT activa el modo TX (activa la transmisión)en el transceptor

int TXdelay=125;  // tiempo de retardo en milisegundos entre la activacion del PTT y en envio de señal


int cwoutPin = 10; // pin arduino por donde se envia n los tonos de CW


const int buzzer = 10;  // pin de arduino por donde se envian los tonos del mensaje de arecibo

// tanto la informacion que se envia en CW (morse), ocmo los tonos del mensaje de arecibo se envian
// por el mismo pin del arduino, ya que en ambos casos de trata de un tono de audio modulado

int laser; // se prevee la conexion de un laser par emitir haces de luz sincronizados con el mensaje (pin 13)

int lowTone = 1000; //A
int highTone = 1010; //E




//**************************************
//*** configuracion de pines arduino ***
//**************************************

void setup()

{

  pinMode(cwoutPin, OUTPUT);      // sets the digital pin as output 

  pinMode(ptt, OUTPUT);

  pinMode(buzzer, OUTPUT); 
  
  pinMode(laser, OUTPUT);

}



//***************************************
//*** bucle de ejecución del programa ***
//***************************************


void loop()

  {
       
    sendbaliza();      // ejecuta la transmision de la baliza
 
    sendfrase();      // ejecuta la transmisión de la frase
 
    sendmemorial();    // ejecuta la transmision del memorial

    sendarecibo();    // ejecuta la trasnmisión del mensaje
 
  delay(10000);      // tiempo de espera (en milisegundos) antes ce comenzar de nuevo el envio
   
  }



//------------------------------------------------

// ***************************
// **definicion de funciones**
// ***************************

//*******************
//**mensaje arecibo**
//*******************

void sendarecibo()

{
  
    digitalWrite(ptt, HIGH);  //Activa la salida PTT y espera TXdelay msg antes de enviar CW
  delay(TXdelay);

  for (int i=0; i < big_string.length(); i++)
  {    
    int outputTone;
    if (big_string[i] == '0') 
    {
      outputTone = lowTone;
      
      laser = 13;  // cuando el bit del mensaje de arecibo es "0" produce un pulso para el laser 
                  // en el pin 13
    }              
    else
    {
      outputTone = highTone;
      
      
    }
    
    digitalWrite(laser, HIGH);
    
    
    tone(buzzer, outputTone, 75);
    
    
    delay(70);
    digitalWrite(laser, LOW);
    
    delay(30);
    

  }
  
  digitalWrite(cwoutPin, LOW);
  digitalWrite(ptt, LOW);  // Desactiva el PTT
 
 
  delay(2000);  // Hace una pausa de 2 segundos
}


//*****************************
//** función para generar CW **
//*****************************
void sendcw(int cwchar)
{
  
 morse = morse_table[cwchar-0x20];
  
while(1){

    if(cwchar == ' '){ // if SPACE character then delay 500 mSec between words
      delay(500);
      return;
    }
    
    if (morse & 0b00000001){ // Compare LSB [ 1 = Dit  0 = Dah ]
      
      for(tone2=0;tone2<100;tone2++){ // Dit timing
        digitalWrite(cwoutPin, HIGH);
        delayMicroseconds(500);
        digitalWrite(cwoutPin, LOW);
        delayMicroseconds(500);
      }
      delay(100);     
    }
    else{
    
      for(tone2=0;tone2<300;tone2++){ // Dah timing
        digitalWrite(cwoutPin, HIGH);
        delayMicroseconds(500);
        digitalWrite(cwoutPin, LOW);
        delayMicroseconds(500);
      }    
      delay(100);    
    }

    morse = morse >> 1; // shift right to see if Dit or Dah

    if(morse == 1){ // if the value is 1 then end of CW character
      delay(200);
      return;
    }
  } // End of Morse while loop
  
} // End of SENDCW routine
// -------------------------------
//
// -------------------------------
// ********************************
// **Rutina de envio de la baliza**
// ********************************

void sendbaliza()
{

  digitalWrite(ptt, HIGH);  //Activa la salida PTT y espera TXdelay msg antes de enviar CW
  delay(TXdelay);

    { 
    for(x=0;x<sizeof(vvv)-1;x++)sendcw(vvv[x]);


    for(x=0;x<sizeof(callsign)-1;x++)sendcw(callsign[x]);


    for(x=0;x<sizeof(locator)-1;x++)sendcw(locator[x]);
    }
  digitalWrite(cwoutPin, LOW);
  digitalWrite(ptt, LOW);  // Desactiva el PTT
 
 
  delay(2000);  // Hace una pausa de 2 segundos
 
}
  
  



  // ************************
  // ** envio del memorial **
  // ************************ 
  
  void sendmemorial()
{

  digitalWrite(ptt, HIGH);  //Activa la salida PTT y espera TXdelay msg antes de enviar CW
  delay(TXdelay);


  
    delay(1000); // Wait 1 second before sending payload




    { 
    for(x=0;x<sizeof(memorial)-1;x++)sendcw(memorial[x]);
    }
    
    
  digitalWrite(cwoutPin, LOW);
  digitalWrite(ptt, LOW);  // Desactiva el PTT
 
 
  delay(2000);  // Hace una pausa de 2 segundos
 
 }

// fin del envio del payload


  // ***********************
  // ** envio de la frase **
  // ***********************  



  void sendfrase()
{

    delay(2000); // Wait 1 second before sending frase
  
   digitalWrite(ptt, HIGH);  //Activa la salida PTT y espera TXdelay msg antes de enviar CW
  delay(TXdelay);




    { 
    for(x=0;x<sizeof(frase)-1;x++)sendcw(frase[x]);
    }
    
    
  digitalWrite(cwoutPin, LOW);
  digitalWrite(ptt, LOW);  // Desactiva el PTT
 
 
  delay(2000);  // Hace una pausa de 2 segundos
 
 }

