/*

"BIO-CODE"

Programa para generar baliza con Arduino en CW y Opera realizado por J.Moldes -EB1HBK-

Produce un tono de audio de 1500 Hz por el pin digital 10 del Arduino. Con este tono se envia
en CW la cabecera de la baliza y a continuación el código en Opera.

PINOUT Arduino:
-pin digtal 12: salida PTT
-pin digital 13: salida 1500 Hz en CW y Opera, cambiado a este pin para poder monitorizar la salida
con el led incorporado en la placa Arduino


Esta basado en los trabajos de:

Jose Antonio Nieto Ros EA5HVK <http://rosmodem.wordpress.com/>

Bill Brown WB8ELK <http://www.wb8elk.com>

Matthew Huges <http://matthewhughes.info/>

y el desarrollo "Balizino" de cacharreo.es <http://cacharreo.es> EA1GDH, EA1HVT, EB1AJP, EB1WM


*/


#include <Flash.h> // necesitas tener esta libreria antes de compilar y cargar el progrma en el Arduino


//***********************************************************************************************************
//**************************** CONFIGURACION DE PARAMETROS DE LA BALIZA *************************************
//***********************************************************************************************************
// al especificar la longitud de las cadenas hay que incluir espacio para el caracter "nulo" de fin de cadena
// NOTA******** Las cadenas "callsign" y "locator" deben configurarse con el distintivo y ubicación adecuados
// dejando ademas un espacio en blanco al final ANTES DE CARGAR EL PROGRAMA EN EL ARDUINO *******************
//***********************************************************************************************************

char vvv[6] = {'V','V','V',' ',' '};              // bloque de tres "V" que identifica el TX de las balizas
char callsign[8] = {'1','2','3','4','5','6',' '}; // SUSTIUIR LOS NUMEROS POR EL DISTINTIVO DE LA ESTACION 
char locator[8] = {'X','X','X','X','X','X',' '};  // SUSTITUIR LAS "X" POR EL LOCATOR GEOGRAFICO


//************************************************************************************************************
//*********************************** Configuracion de la Baliza en CW ***************************************
//************************************************************************************************************

// Duracion del punto en CW (la duracion de la raya, espacio entre letras y palabras
// se ajustan solos segun el valor del punto

int punto = 100; //tiempo en milisegundos


long intervalo = 5; //tiempo de espera entre sucesivas secuencias de transmision (en minutos) completa

// Atencion!! la secuencia de transmision comleta consta de la cabecera en CW (VVV + distintivo + locator) mas
// el numero de veces que se repita al secuencia de opera (se determina en la variable "repetir")
// con los valores actuales, hay una espera de 5 minutos entre cada secuencia de transmision completa.
// cada secuencia cosnta de cabera en CW y cinco repeticiones de Opera con una pausa intermendia de 60 segundos.

//************************************************************************************************************
//****************** Variable de tiempo del bit (en milisegundos) segun el modo OPERA ************************
//************************************************************************************************************


/* 
Opera05= 128;
Opera1= 256;
Opera2= 512;
Opera4= 1024;
Opera8= 2048;
Opera32= 8192;
Opera65= 16384;
Opera2H= 32768;
*/


int opera= 128;  // AJUSTAR ESTA VARIABLE SEGUN EL MODO OPERA DESEADO (VER LA TABLA ANTERIOR)

long pausa= 60; //tiempo de espera (en segundos) entre transmisiones Opera

int repetir= 5;  // numero de veces que se repite el codigo Opera antes de volver a enviar la cabecera en CW




// Copiar aqui (entre las comillas del big_string) el código binario generado por el programa Opera para la transmisión

FLASH_STRING
(big_string, 
  "REEMPLAZAR ESTE TEXTO ENTRE LAS COMILLAS. CON EL CODIGO DE BITS GENERADO POR EL PROGRAMA OPERA EN EL MENU 'Pic' UNA VEZ CORRECTAMENTE CONFIGURADO"
);










//************************************************************************************************************
//************************************************************************************************************
//************************************************************************************************************
//********************************* Fin de los ajustes de configuracion **************************************
//************************************************************************************************************
//************************************************************************************************************
//************************************************************************************************************
















// ********************************************************
// ASCII to Morse Code Lookup Table
// ********************************************************

const unsigned char morse_table[63] = { 	// Morse Code Lookup table

	0b00000001,	//;sp - 0x20 
	0b01001010,	//; ! - 0x21
	0b01101101,	//; " - 0x22
	0b01011110,	//; # - 0x23 // Not available in Morse Code - replace with "-"
	0b10110111,	//; $ - 0x24
	0b01011110,	//; % - 0x25 // Not available in Morse Code - replace with "-"
	0b00111101,	//; & - 0x26
	0b01100001,	//; ' - 0x27
	0b00110010,	//; ( - 0x28
	0b01010010,	//; ) - 0x29
	0b01011110,	//; * - 0x2A // Not available in Morse Code - replace with "-"
	0b00110101,	//; + - 0x2B 
	0b01001100,     //; , - 0x2C
	0b01011110,     //; - - 0x2D
	0b01010101,     //; . - 0x2E
	0b00110110,	//; / - 0x2F
	0b00100000,	//; 0 - 0x30
	0b00100001,	//; 1 - 0x31
	0b00100011,	//; 2 - 0x32
	0b00100111,	//; 3 - 0x33
	0b00101111,	//; 4 - 0x34
	0b00111111,	//; 5 - 0x35
	0b00111110,	//; 6 - 0x36
	0b00111100,	//; 7 - 0x37
	0b00111000,	//; 8 - 0x38
	0b00110000,	//; 9 - 0x39
	0b01111000,	//; : - 0x3A
	0b00101010,	//; ; - 0x3B
	0b00110010,	//; < - 0x3C // send ( since no < in Morse
	0b00101110,	//; = - 0x3D 
	0b01010010,	//; > - 0x3E // send ) since no > in Morse
	0b01110011,	//; ? - 0x3F
	0b01101001,	//; @ - 0x40 
	0b00000101,	//; A - 0x41
	0b00011110,	//; B - 0x42
	0b00011010,	//; C - 0x43
	0b00001110,	//; D - 0x44
	0b00000011,	//; E - 0x45
	0b00011011,	//; F - 0x46
	0b00001100,	//; G - 0x47
	0b00011111,	//; H - 0x48
	0b00000111,	//; I - 0x49
	0b00010001,	//; J - 0x4A
	0b00001010,	//; K - 0x4B
	0b00011101,	//; L - 0x4C
	0b00000100,	//; M - 0x4D
	0b00000110,	//; N - 0x4E
	0b00001000,	//; O - 0x4F
	0b00011001,	//; P - 0x50
	0b00010100,	//; Q - 0x51
	0b00001101,	//; R - 0x52
	0b00001111,	//; S - 0x53
	0b00000010,	//; T - 0x54
	0b00001011,	//; U - 0x55
	0b00010111,	//; V - 0x56
	0b00001001,	//; W - 0x57
	0b00010110,	//; X - 0x58
	0b00010010,	//; Y - 0x59
	0b00011100	//; Z - 0x5A
	
};

// END of Morse Table









int adclen;
byte morse;
byte cwlen;
byte cw;

byte x;
char asciibuf[5];

int tone2=0;

int raya=(punto*3);

int espaciocaracter=(punto*2);

int espaciopalabra=(punto*7);

int ptt = 12; // PTT activa el modo TX (activa la transmisión)en el transceptor

int TXdelay=125;  // tiempo de retardo en milisegundos entre la activacion del PTT y en envio de señal


int cwoutPin = 13; // pin arduino por donde se envian los tonos de CW


const int buzzer = 13;  // pin de arduino por donde se envian los tonos de Opera



long pausa2=(pausa*1000);      //convierte los segundos de pausa entre transmisiones de Opera a milisegundos.

long intervalo2=(intervalo*60000); //convierte los minutos del intervalo a milisegundos para el retardo.



int lowTone = 0; //A
int highTone = 1498; //E




//**************************************
//*** configuracion de pines arduino ***
//**************************************

void setup()

{

  pinMode(cwoutPin, OUTPUT);      // sets the digital pin as output 

  pinMode(ptt, OUTPUT);

  pinMode(buzzer, OUTPUT); 
  

}



//***************************************
//*** bucle de ejecución del programa ***
//***************************************


void loop()

  {
       
    sendbaliza();      // ejecuta la transmision de la baliza
 
  for (int x=0; x<repetir; x++){
  
    sendOpera();    // ejecuta la traNSmisión del mensaje Opera tantas veces como lo indique la variable "repetir"
 
  delay(pausa2);      // tiempo de espera (en milisegundos) entre secuencias TX de Opera
  }
  
  delay (intervalo2);    //tiempo de espera (en milisegundos) entre secuencias completas con cabecera en CW
  }



//------------------------------------------------

// ***************************
// **definicion de funciones**
// ***************************

//*******************
//**codigo OPERA**
//*******************

void sendOpera()

{
  
    digitalWrite(ptt, HIGH);  //Activa la salida PTT y espera TXdelay msg antes de enviar CW
  delay(TXdelay);

  for (int i=0; i < big_string.length(); i++)
  {    
    int outputTone;
    if (big_string[i] == '0') 
    {
      outputTone = lowTone;
      

    }              
    else
    {
      outputTone = highTone;
      
      
    }
    
    
    
    
    tone(buzzer, outputTone, opera);
    
    
    delay(opera);
  
    

  }
  
  digitalWrite(cwoutPin, LOW);
  digitalWrite(ptt, LOW);  // Desactiva el PTT
 
 
  delay(2000);  // Hace una pausa de 2 segundos
}


//*****************************
//** función para generar CW **
//*****************************
void sendcw(int cwchar)
{
  
 morse = morse_table[cwchar-0x20];
  
while(1){

    if(cwchar == ' '){ // if SPACE character then delay 500 mSec between words
      delay(espaciopalabra);
      return;
    }
    
    if (morse & 0b00000001){ // Compare LSB [ 1 = Dit  0 = Dah ]
      
      for(tone2=0;tone2<punto;tone2++){ // Dit timing
        digitalWrite(cwoutPin, HIGH);
        delayMicroseconds(326);
        digitalWrite(cwoutPin, LOW);
        delayMicroseconds(326);
      }
      delay(espaciocaracter);     
    }
    else{
    
      for(tone2=0;tone2<raya;tone2++){ // Dah timing
        digitalWrite(cwoutPin, HIGH);
        delayMicroseconds(326);
        digitalWrite(cwoutPin, LOW);
        delayMicroseconds(326);
      }    
      delay(espaciocaracter);    
    }

    morse = morse >> 1; // shift right to see if Dit or Dah

    if(morse == 1){ // if the value is 1 then end of CW character
      delay(espaciocaracter);
      return;
    }
  } // End of Morse while loop
  
} // End of SENDCW routine
// -------------------------------
//
// -------------------------------
// ********************************
// **Rutina de envio de la baliza**
// ********************************

void sendbaliza()
{

  digitalWrite(ptt, HIGH);  //Activa la salida PTT y espera TXdelay msg antes de enviar CW
  delay(TXdelay);

    { 
    for(x=0;x<sizeof(vvv)-1;x++)sendcw(vvv[x]);


    for(x=0;x<sizeof(callsign)-1;x++)sendcw(callsign[x]);


    for(x=0;x<sizeof(locator)-1;x++)sendcw(locator[x]);
    }
  digitalWrite(cwoutPin, LOW);
  digitalWrite(ptt, LOW);  // Desactiva el PTT
 
 
  delay(2000);  // Hace una pausa de 2 segundos
 
}
  
  

